ScriptName SuitUp:QuestScript Extends Quest

Actor Property PlayerRef Mandatory Const Auto

Perk Property _su_handlerperk Mandatory Const Auto
{ This holds effects as well as notifications. }
GameplayOption Property _su_enabledGPO Mandatory Const Auto
{ 0 is enabled, 1 is disabled }
Message Property _su_Sys_Disabled Mandatory Const Auto
Message Property _su_Sys_Enabled Mandatory Const Auto

Function PerkHandler()
    Utility.Wait(0.1)
    int Mode = _su_enabledGPO.GetValue() as int
    If Mode == 0
        If  !PlayerRef.HasPerk(_su_handlerperk)
            PlayerRef.AddPerk(_su_handlerperk)
            _su_Sys_Enabled.Show()
        EndIf
    ElseIf Mode == 1
        If  PlayerRef.HasPerk(_su_handlerperk)
            PlayerRef.RemovePerk(_su_handlerperk)
            _su_Sys_Disabled.Show()
        EndIf
    EndIf
EndFunction

Event OnQuestInit()
	StartTimer(4)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
        RegisterForGameplayOptionChangedEvent()
        PerkHandler()
        GoToState("")
    EndEvent
EndState

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    PerkHandler()
EndEvent